﻿using System;
using System.IO;

namespace DynamicAutomation
{
    class Program
    {
        // Listing 18-6. Automatyzacja COM i słowo kluczowe dynamic
        static void Main(string[] args)
        {
            Type appType = Type.GetTypeFromProgID("Word.Application");
            dynamic wordApp = Activator.CreateInstance(appType);

            string docPath = Path.Combine(Environment.CurrentDirectory, "WordFile.docx");
            dynamic doc = wordApp.Documents.Open(docPath, ReadOnly: true);
            dynamic docProperties = doc.BuiltInDocumentProperties;
            string authorName = docProperties["Author"].Value;
            doc.Close(SaveChanges: false);
            Console.WriteLine(authorName);
        }
    }
}
